
package birthnumerology.findyourfate.com;


import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdView;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;

public class curlsagg9 extends Activity {
	private AdView mAdview;

	private CurlView mCurlView;
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		mAdview = (AdView) findViewById(R.id.adView);
	    mAdview.setAdListener(new ToastAdListener(this));


		int index = 0;
		if (getLastNonConfigurationInstance() != null) {
			index = (Integer) getLastNonConfigurationInstance();
		}
		mCurlView = (CurlView) findViewById(R.id.curl);
		mCurlView.setPageProvider(new PageProvider());
		mCurlView.setSizeChangedObserver(new SizeChangedObserver());
		mCurlView.setCurrentIndex(index);
		mCurlView.setBackgroundColor(0xffffff);
		//mCurlView.setBackgroundColor(Color.TRANSPARENT);
		// This is something somewhat experimental. Before uncommenting next
		// line, please see method comments in CurlView.
		// mCurlView.setEnableTouchPressure(true);
		mCurlView.setAllowLastPageCurl(false);
 	    mAdview.loadAd(new AdRequest.Builder().build()); 
	}

	@Override
	public void onPause() {
		super.onPause();
		mCurlView.onPause();
	}
	public void onBackPressed() {
	     //  this.finish();
		curlsagg9.this.finish();
	} 
	@Override
	public void onResume() {
		super.onResume();
		mCurlView.onResume();
	}
	@Override
	public Object onRetainNonConfigurationInstance() {
		return mCurlView.getCurrentIndex();
	}

	/**
	 * Bitmap provider.
	 */
	private class PageProvider implements CurlView.PageProvider {

		// Bitmap resources.
		private int[] mBitmapIds = { R.drawable.sa90, R.drawable.sa91,
				R.drawable.sa92, R.drawable.sa93};

		@Override
		public int getPageCount() {
			return 4;
		}

		private Bitmap loadBitmap(int width, int height, int index) {
			Bitmap b = Bitmap.createBitmap(width, height,
					Bitmap.Config.ARGB_8888);
			b.eraseColor(0xFFffffff);
			Canvas c = new Canvas(b);
			Drawable d = getResources().getDrawable(mBitmapIds[index]);

			int margin =0;
			int border = 3;
			Rect r = new Rect(margin, margin, width - margin, height - margin);

			int imageWidth = r.width() - (border * 2)+80;
			int imageHeight = imageWidth * d.getIntrinsicHeight()
					/ d.getIntrinsicWidth();
			if (imageHeight > r.height() - (border * 2)) {
				imageHeight = r.height() - (border * 2);
				imageWidth = imageHeight * d.getIntrinsicWidth()
						/ d.getIntrinsicHeight();
			}

			r.left += ((r.width() - imageWidth) / 2) - border;
			r.right = r.left + imageWidth + border + border;
			r.top += ((r.height() - imageHeight) / 2) - border;
			r.bottom = r.top + imageHeight + border + border;

			Paint p = new Paint();
			p.setColor(0xFF080c08);
			c.drawRect(r, p);
			r.left += border;
			r.right -= border;
			r.top += border;
			r.bottom -= border;

			d.setBounds(r);
			d.draw(c);

			return b;
			
			
		}

		@Override
		public void updatePage(CurlPage page, int width, int height, int index) {

			switch (index) {
			// First case is image on front side, solid colored back.
			case 0: {
				Bitmap front = loadBitmap(width, height, 0);
				page.setTexture(front, CurlPage.SIDE_BOTH);
				page.setColor(Color.argb(127, 255, 255, 255),
						CurlPage.SIDE_BACK);
				break;
			}
			// Second case is image on back side, solid colored front.
			case 1: {
				Bitmap front = loadBitmap(width, height, 1);
				page.setTexture(front, CurlPage.SIDE_BOTH);
				page.setColor(Color.argb(127, 255, 255, 255),
						CurlPage.SIDE_BACK);
				break;
			}
			// Third case is images on both sides.
			case 2: {
				Bitmap front = loadBitmap(width, height, 2);
				page.setTexture(front, CurlPage.SIDE_BOTH);
				page.setColor(Color.argb(127, 255, 255, 255),
						CurlPage.SIDE_BACK);
				break;
			}
			// Fourth case is images on both sides - plus they are blend against
			// separate colors.
			case 3: {
				Bitmap front = loadBitmap(width, height,3);
				page.setTexture(front, CurlPage.SIDE_BOTH);
				page.setColor(Color.argb(127, 255, 255, 255),
						CurlPage.SIDE_BACK);
				break;
			}
			// Fifth case is same image is assigned to front and back. In this
			// scenario only one texture is used and shared for both sides.
		/*	case 4:
				Bitmap front = loadBitmap(width, height,4);
				page.setTexture(front, CurlPage.SIDE_BOTH);
				page.setColor(Color.argb(127, 255, 255, 255),
						CurlPage.SIDE_BACK);
				break; */
			}
		}
	}
	/**
	 * CurlView size changed observer.
	 */
	private class SizeChangedObserver implements CurlView.SizeChangedObserver {
		@Override
		public void onSizeChanged(int w, int h) {
			if (w > h) {
				mCurlView.setViewMode(CurlView.SHOW_TWO_PAGES);
				mCurlView.setMargins(0f, 0f, 0f, 0f);
			} else {
				mCurlView.setViewMode(CurlView.SHOW_ONE_PAGE);
				mCurlView.setMargins(0f, 0f, 0f, 0f);
			}
		}
	}

		


@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater inflater = getMenuInflater();
	//MenuInflater inflater = getMenuInflater();
	inflater.inflate(R.menu.main, menu); 
	 return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// toggle nav drawer on selecting action bar app icon/title
		 
		 			if(item.getItemId() == R.id.share)
		 		{
				 Intent emailIntent = new Intent(android.content.Intent.ACTION_SEND);
	     	     emailIntent.setType("text/plain");
	     	     emailIntent.putExtra(android.content.Intent.EXTRA_SUBJECT, "Birthday Numerology - findyourfate.com");
	             emailIntent.putExtra(android.content.Intent.EXTRA_TEXT,"Hi,\n I would like to suggest, this Birthday Numerology App to you. \n\n  Click this Download app \" http://goo.gl/VfJLbc \"\n\n Regards");
	     	     startActivity(emailIntent);
		 		}
	     	 	else  if (item.getItemId() == R.id.exit)
		     	{
		 	       	AlertDialog.Builder builder = new AlertDialog.Builder(this);
				    builder.setMessage("Are you sure  want to exit?")
				           .setCancelable(false)
				           .setPositiveButton("Yes", new DialogInterface.OnClickListener() {
				               public void onClick(DialogInterface dialog, int id) {
				            	   Intent intent = new Intent(Intent.ACTION_MAIN);
				   		    	intent.addCategory(Intent.CATEGORY_HOME);
				   		    	intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
				   		    	startActivity(intent);
				               }
				           })
				           .setNegativeButton("No", new DialogInterface.OnClickListener() {
				               public void onClick(DialogInterface dialog, int id) {
				                    dialog.cancel();
				               }
				           });
				    AlertDialog alert = builder.create();
				    alert.show();
		     		  }
			 else if (item.getItemId() == R.id.in)
     		  {
     			  AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(curlsagg9.this);
     			 alertDialogBuilder.setTitle("Numerology Calculator");
     			 alertDialogBuilder.setMessage("This app need to enter the birth date and the complete name of an individual to unlock all of the secrets that the numbers hold and then the future course of the individual can be derived from it.");
     			 alertDialogBuilder.setPositiveButton("Open",new DialogInterface.OnClickListener() {
     			  public void onClick(DialogInterface dialog,int id) {
     			      final String appPackageName = "numerology.findyourfate.com"; // getPackageName() from Context or Activity object
     			        	try {
     			        	   startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
     			        	  } catch (android.content.ActivityNotFoundException anfe) {
     			        	       startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://play.google.com/store/apps/details?id=" + appPackageName)));
     			        	     }
     			        }
     			     });
     			   alertDialogBuilder.setNeutralButton("Already/Never",new DialogInterface.OnClickListener() {
     			      public void onClick(DialogInterface dialog,int id) {	  
     			         //  MainActivity.this.finish();
     			       dialog.cancel();
     			                  }
     			             });
     			          // set negative button: No message
     				alertDialogBuilder.setNegativeButton("Later",new DialogInterface.OnClickListener() {
     		        public void onClick(DialogInterface dialog,int id) {
     			                      // cancel the alert box and put a Toast to the user
     			         dialog.cancel();                    
     			                  }
     			          });
     			           AlertDialog alertDialog = alertDialogBuilder.create();
     			           // show alert
     			           alertDialog.show();			  
     			      }
     		return  true;
		}

}


